


;-----------------------------------------------------------------------------------------------------------------------------------------------------
;																									
;	( INTER-C33 )																						
;																									
;-----------------------------------------------------------------------------------------------------------------------------------------------------
;																									
;	DETERMINA INTERSECCION DE PLANOS TANGENTES																	
;																									
;	DEL TRIO DE PUNTOS (MUY PROSIMOS) ( A1Y A2C A3X ) DE PUNTOS EN QUE SE DIVIDE UNA CURVA CONTICUA-NO-PLANA (CON CURVATURA EN EL NISMO SENTIDO ?)	
;																									
;	PINTA DOS 3DCARA EN CADA PLANO TANGENTE																		
;																									
;-----------------------------------------------------------------------------------------------------------------------------------------------------


;	SELECCION SECCION "X"  PUNTEANDOLA A N DIVISIONES (Ndivi) => (LISTA-PX)													

(DEFUN PUNTOS-X (/ )
	(SETQ NA00 (NTH 0 SA00))										; Nombre Spline A 
	(SETQ AELES (MEMBER (ASSOC 10 (ENTGET NA00)) (ENTGET NA00)))				; Lista a partir del elemento (incluido)
	(SETQ A-primer (CDR (NTH 0 AELES)))									; Primer elemento
	(SETQ A-ultimo (CDR (NTH (- (LENGTH AELES) 1) AELES)))					; Ultimo elemento
	(COMMAND "-color" 1)											; ROJO
	(COMMAND "PUNTO" A-primer) (SETQ NPA0 (ENTLAST))					 	; Nombre ultima entidad principal 1 punto
	(COMMAND "-color" 8)											; GRIS-8
	(COMMAND "DIVIDE" NA00 Ndivi) 				 					; DIVIDE CON PUNTOS SPLINE
	(COMMAND "-color" 5) 					 						; AZUL
	(COMMAND "PUNTO" A-ultimo)

	;	PUNTOS SECCION X (PX1-PXn) =>  LISTA-PX  												
	(SETQ NPA1 nil)
	(SETQ LISTA-PX nil)
	(SETQ LISTA-PX (LIST (CDR (ASSOC 10 (ENTGET NPA0))))) 	 				;LISTA-PX => 1 punto
	(SETQ WH-1 T)
	(WHILE WH-1
		(SETQ NPA1 (ENTNEXT NPA0))			 						;nombre entidad siguiente
		(IF (= NPA1 nil)
			(SETQ WH-1 nil)
			(PROGN
				(SETQ LISTA-PX (CONS (CDR (ASSOC 10 (ENTGET NPA1))) LISTA-PX))	;=> resto Puntos
				(SETQ NPA0 NPA1)
			) ;progn
		) ;if
	) ;While WH-1

	(SETQ LISTA-PX (REVERSE LISTA-PX))

) ;cierre DEFUN PUNTOS-X
;																									



;-----------------------------------------------------------------------------------------------------------------------------------------------------
;																									
;       *** PROGRAMA *** PROGRAMA *** PROGRAMA *** PROGRAMA *** PROGRAMA*** PROGRAMA*** 											
;																									
;-----------------------------------------------------------------------------------------------------------------------------------------------------
;	ENTRADAS: 
;	SALIDAS : 
;	INTERNAS: 

(DEFUN C:INTER-C33 (/  )
	(SETVAR "blipmode" 0) (SETVAR "cmdecho" 0) (GRAPHSCR) (COMMAND "-REFENT" "DES") (COMMAND "SCP" "U")
  
;-----------------------------------------------------------------------------------------------------------------------------------------------------
;	FIJA PARAMETROS																						
;-----------------------------------------------------------------------------------------------------------------------------------------------------


	(SETQ Nsecc 51)									; N de SECCIONES
	(SETQ Ndivi (+ (* Nsecc 100) 2))						; N DIVISIONES DE DIVIDE (Ndivi)


	(SETQ A-cami  0.3  )								; SEMI-ANCHO CAMINO


;-----------------------------------------------------------------------------------------------------------------------------------------------------


;	LISTA PUNTOS SPLINE	(LISTA-PX)																	(LISTA-PX)		

	(SETQ SA00 (ENTSEL " ------------------------- SELECCIONE SPLINE  ")) (TERPRI)

	(PUNTOS-X)										; => (LISTA-PX)

;	ALGORIDMOS																							
  
	(SETQ N1 -101)
	(SETQ K     5)
	(SETQ N2    0)


	(REPEAT Nsecc

		(SETQ N1 (+ N1 100))

		(SETQ A1Y (NTH (+ N1   1) LISTA-PX)) 				; Punto P1A-Y
		(SETQ A2C (NTH (+ N1   2) LISTA-PX)) 				; Punto P2A-Origen
		(SETQ A3X (NTH (+ N1   3) LISTA-PX)) 				; Punto P3A-X

		(SETQ B1Y (NTH (+ N1 101) LISTA-PX)) 				; Punto P1B-Y
		(SETQ B2C (NTH (+ N1 102) LISTA-PX)) 				; Punto P2B-Origen
		(SETQ B3X (NTH (+ N1 103) LISTA-PX)) 				; Punto P3B-X

		(COMMAND "SCP" "3P" A2C A3X A1Y) 					; SCP=A  (PLANO-OSCULADOR A)
 			(SETQ P1A (TRANS A1Y 0 1))
			(SETQ P2A (TRANS A2C 0 1))
			(SETQ AgA (+ (/ (ANGLE P2A P1A) 2) (/ PI 2)))
			(SETQ CAC (LIST 0 0 0))
			(SETQ CAX (LIST (* K (COS AgA)) (* K (SIN AgA)) 0))	; TAG-A (AC AX) SCP
			(SETQ CAY (LIST 0 0 K))
 			(SETQ CACU (TRANS CAC 1 0))					; PLANO-TAG-A (AC AX AY) SCU
 			(SETQ CAXU (TRANS CAX 1 0))
 			(SETQ CAYU (TRANS CAY 1 0))
		(COMMAND "SCP" "U")


		(COMMAND "SCP" "3P" B2C B3X B1Y) 					; SCP=B    (PLANO-OSCULADOR B)
 			(SETQ P1B (TRANS B1Y 0 1))
			(SETQ P2B (TRANS B2C 0 1))
			(SETQ AgB (+ (/ (ANGLE P2B P1B) 2) (/ PI 2)))
			(SETQ CBC (LIST 0 0 0))
			(SETQ CBX (LIST (* K (COS AgB)) (* K (SIN AgB)) 0))	; TAG-B (BC BX) SCP
			(SETQ CBY (LIST 0 0 K))
 			(SETQ CBCU (TRANS CBC 1 0))					; PLANO-TANG-B (BC BX BY) SCU
 			(SETQ CBXU (TRANS CBX 1 0))
 			(SETQ CBYU (TRANS CBY 1 0))
		(COMMAND "SCP" "U")


		(COMMAND "SCP" "3P" CACU CAXU CAYU) 				; SCP=TA (PLANO-TAG-A)
 			(SETQ CBCta (TRANS CBCU 0 1))
 			(SETQ CBXta (TRANS CBXU 0 1))
			(SETQ CBCta0 (LIST (CAR CBCta) (CADR CBCta) 0))
			(SETQ CBXta0 (LIST (CAR CBXta) (CADR CBXta) 0))
 			(SETQ CBCta0U (TRANS CBCta0 1 0))				; Troyeccion CBCU => SCP=TA
 			(SETQ CBXta0U (TRANS CBXta0 1 0))				; Troyeccion CBXU => SCP=TA
		(COMMAND "SCP" "U")

		(COMMAND "SCP" "3P" CBCU CBXU CBYU) 				; SCP=TB (PLANO-TAG-B)
 			(SETQ CACtb (TRANS CACU 0 1))
 			(SETQ CAXtb (TRANS CAXU 0 1))
			(SETQ CACtb0 (LIST (CAR CACtb) (CADR CACtb) 0))
			(SETQ CAXtb0 (LIST (CAR CAXtb) (CADR CAXtb) 0))
 			(SETQ CACtb0U (TRANS CACtb0 1 0))				; Troyeccion CACU => SCP=TB
 			(SETQ CAXtb0U (TRANS CAXtb0 1 0))				; Troyeccion CAXU => SCP=TB
		(COMMAND "SCP" "U")

		(SETQ INT-A (INTERS  CACU  CAXU  CACtb0U  CAXtb0U  nil))
		(SETQ INT-B (INTERS  CBCU  CBXU  CBCta0U  CBXta0U  nil))

		;(SETQ INT-MEDI 	(LIST	(+ (CAR   INT-A) (/ (- (CAR   INT-B) (CAR   INT-A)) 2))
		;				(+ (CADR  INT-A) (/ (- (CADR  INT-B) (CADR  INT-A)) 2))
		;				(+ (CADDR INT-A) (/ (- (CADDR INT-B) (CADDR INT-A)) 2)) ))
		;(COMMAND "SCP" "3P" INT-A  INT-B  CACU) 				; SCP=IN (PLANO-INTERSECCION)
		;	(SETQ CANI1 (LIST    A-cami  0 0))
		;	(SETQ CANI2 (LIST (- A-cami) 0 0))
 		;	(SETQ CANI1U (TRANS CANI1 1 0))				; TRAVIESA CAMINO
 		;	(SETQ CANI2U (TRANS CANI2 1 0))
		;(COMMAND "SCP" "U")
		;(COMMAND "COLOR" 7 "LINEA" CANI1U CANI2U "")

		(COMMAND "SCP" "3P" A2C  INT-A  INT-B) 				; SCP=CA (CARA-A)
			(SETQ CANI-A1 (LIST 0    A-cami  0 ))
			(SETQ CANI-A2 (LIST 0 (- A-cami) 0 ))
			(SETQ CANI-A3 (LIST K    A-cami  0 ))
			(SETQ CANI-A4 (LIST K (- A-cami) 0 ))

 			(SETQ CANI-A1U (TRANS CANI-A1 1 0))				; TRAVIESA PERPENDICULAR CAMINO-A
 			(SETQ CANI-A2U (TRANS CANI-A2 1 0))
 			(SETQ CANI-A3U (TRANS CANI-A3 1 0))
 			(SETQ CANI-A4U (TRANS CANI-A4 1 0))
		(COMMAND "SCP" "U")


		(COMMAND "SCP" "3P" B2C  INT-B  INT-A) 				; SCP=CB (CARA-B)
			(SETQ CANI-B1 (LIST 0    A-cami  0 ))
			(SETQ CANI-B2 (LIST 0 (- A-cami) 0 ))
			(SETQ CANI-B3 (LIST K    A-cami  0 ))
			(SETQ CANI-B4 (LIST K (- A-cami) 0 ))

 			(SETQ CANI-B1U (TRANS CANI-B1 1 0))				; TRAVIESA PERPENDICULAR CAMINO-B
 			(SETQ CANI-B2U (TRANS CANI-B2 1 0))
 			(SETQ CANI-B3U (TRANS CANI-B3 1 0))
 			(SETQ CANI-B4U (TRANS CANI-B4 1 0))
		(COMMAND "SCP" "U")

		(SETQ IN-A1 (INTERS  CANI-A1U  CANI-A3U  INT-A  INT-B  nil))
		(SETQ IN-A2 (INTERS  CANI-A2U  CANI-A4U  INT-A  INT-B  nil))
		(SETQ IN-B1 (INTERS  CANI-B2U  CANI-B4U  INT-A  INT-B  nil))
		(SETQ IN-B2 (INTERS  CANI-B1U  CANI-B3U  INT-A  INT-B  nil))

		(SETQ IN-M-A1B1 	(LIST	(+ (CAR   IN-A1) (/ (- (CAR   IN-B1) (CAR   IN-A1)) 2))	; PUNTO-MEDIO (IN-A1 IN-B1)
						(+ (CADR  IN-A1) (/ (- (CADR  IN-B1) (CADR  IN-A1)) 2))
						(+ (CADDR IN-A1) (/ (- (CADDR IN-B1) (CADDR IN-A1)) 2)) ))

		(SETQ IN-M-A2B2 	(LIST	(+ (CAR   IN-A2) (/ (- (CAR   IN-B2) (CAR   IN-A2)) 2))	; PUNTO-MEDIO (IN-A2 IN-B2)
						(+ (CADR  IN-A2) (/ (- (CADR  IN-B2) (CADR  IN-A2)) 2))
						(+ (CADDR IN-A2) (/ (- (CADDR IN-B2) (CADDR IN-A2)) 2)) ))

		(SETQ N2 (+ N2 1)  COLO (REM N2 2))
		(COND 
			(  (= COLO 0) (SETQ ColoA 2 ColoB 1)  )
			(  (= COLO 1) (SETQ ColoA 1 ColoB 2)  )
		) ; cond


		(COMMAND "COLOR" ColoA  "3DCARA" CANI-A1U  CANI-A2U  IN-M-A2B2  IN-M-A1B1 "")		; CARA-A
		(COMMAND "COLOR" ColoB  "3DCARA" CANI-B2U  CANI-B1U  IN-M-A2B2  IN-M-A1B1 "")		; CARA-B

	) ; cierre Repeat

;	PARANDO																							
	(SETVAR "blipmode" 1) (SETVAR "cmdecho" 1)
) ;cierre DEFUN INTER-C33 
;																									